﻿////////////////////////////////////////////////////////////////////////
//                    OpenPage
////////////////////////////////////////////////////////////////////////
//                   2010-02-23
//                   Weiher Johann
////////////////////////////////////////////////////////////////////////

using System.Collections.Generic;
using System.Text;
using Eplan.EplApi.Gui;
using System.IO;
using System.Collections;
using System.Diagnostics;
using System.Globalization;
public class FrmOpenPage : System.Windows.Forms.Form
{

    ////////////////////////////////////////////////////////////////////////
    // Form
    ////////////////////////////////////////////////////////////////////////
    #region Formular
    public FrmOpenPage()
    {
        InitializeComponent();
    }
    private System.Windows.Forms.Button btnCancel;
    private System.Windows.Forms.ToolStripStatusLabel lblStatus2;
    private System.Windows.Forms.Label label2;
    private System.Windows.Forms.TextBox txtFunction;
    private System.Windows.Forms.Label label1;
    private System.Windows.Forms.Label label3;
    private System.Windows.Forms.TextBox txtPlant;
    private System.Windows.Forms.Label label4;
    private System.Windows.Forms.TextBox txtLocation;
    private System.Windows.Forms.Label label5;
    private System.Windows.Forms.TextBox txtMountLoc;
    private System.Windows.Forms.Label label6;
    private System.Windows.Forms.TextBox txtPlantNr;
    private System.Windows.Forms.Label label7;
    private System.Windows.Forms.TextBox txtDocument;
    private System.Windows.Forms.Label label8;
    private System.Windows.Forms.TextBox txtUserDef;
    private System.Windows.Forms.Label label9;
    private System.Windows.Forms.TextBox txtPagename;
    private System.Windows.Forms.TextBox textBox1;
    private System.Windows.Forms.TextBox textBox2;
    private System.Windows.Forms.TextBox textBox3;
    private System.Windows.Forms.TextBox textBox4;
    private System.Windows.Forms.TextBox txtPlantNrIndex;
    private System.Windows.Forms.TextBox textBox6;
    private System.Windows.Forms.TextBox textBox7;
    private System.Windows.Forms.TextBox textBox8;
    private System.Windows.Forms.Label label10;
    private System.Windows.Forms.TextBox txtFullPagename;


    ///
    /// Erforderliche Designervariable.
    ///
    private System.ComponentModel.IContainer components = null;

    ///
    /// Verwendete Ressourcen bereinigen.
    ///
    /// True, wenn verwaltete Ressourcen gelöscht werden sollen; andernfalls False.
    protected override void Dispose(bool disposing)
    {
        if (disposing && (components != null))
        {
            components.Dispose();
        }
        base.Dispose(disposing);
    }

    #region Vom Windows Form-Designer generierter Code

    ///
    /// Erforderliche Methode für die Designerunterstützung.
    /// Der Inhalt der Methode darf nicht mit dem Code-Editor geändert werden.
    ///
    private void InitializeComponent()
    {
        this.btnOK = new System.Windows.Forms.Button();
        this.btnCancel = new System.Windows.Forms.Button();
        this.lblStatus2 = new System.Windows.Forms.ToolStripStatusLabel();
        this.txtFunction = new System.Windows.Forms.TextBox();
        this.label1 = new System.Windows.Forms.Label();
        this.label3 = new System.Windows.Forms.Label();
        this.txtPlant = new System.Windows.Forms.TextBox();
        this.label4 = new System.Windows.Forms.Label();
        this.txtLocation = new System.Windows.Forms.TextBox();
        this.label5 = new System.Windows.Forms.Label();
        this.txtMountLoc = new System.Windows.Forms.TextBox();
        this.label6 = new System.Windows.Forms.Label();
        this.txtPlantNr = new System.Windows.Forms.TextBox();
        this.label7 = new System.Windows.Forms.Label();
        this.txtDocument = new System.Windows.Forms.TextBox();
        this.label8 = new System.Windows.Forms.Label();
        this.txtUserDef = new System.Windows.Forms.TextBox();
        this.label9 = new System.Windows.Forms.Label();
        this.txtPagename = new System.Windows.Forms.TextBox();
        this.textBox1 = new System.Windows.Forms.TextBox();
        this.textBox2 = new System.Windows.Forms.TextBox();
        this.textBox3 = new System.Windows.Forms.TextBox();
        this.textBox4 = new System.Windows.Forms.TextBox();
        this.txtPlantNrIndex = new System.Windows.Forms.TextBox();
        this.textBox6 = new System.Windows.Forms.TextBox();
        this.textBox7 = new System.Windows.Forms.TextBox();
        this.textBox8 = new System.Windows.Forms.TextBox();
        this.label10 = new System.Windows.Forms.Label();
        this.txtFullPagename = new System.Windows.Forms.TextBox();
        this.SuspendLayout();
        // 
        // btnOK
        // 
        this.btnOK.Location = new System.Drawing.Point(310, 222);
        this.btnOK.Name = "btnOK";
        this.btnOK.Size = new System.Drawing.Size(72, 24);
        this.btnOK.TabIndex = 2;
        this.btnOK.Text = "OK";
        this.btnOK.UseVisualStyleBackColor = true;
        this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
        // 
        // btnCancel
        // 
        this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
        this.btnCancel.Location = new System.Drawing.Point(388, 222);
        this.btnCancel.Name = "btnCancel";
        this.btnCancel.Size = new System.Drawing.Size(72, 24);
        this.btnCancel.TabIndex = 16;
        this.btnCancel.Text = "Cancel";
        this.btnCancel.UseVisualStyleBackColor = true;
        this.btnCancel.Click += new System.EventHandler(this.btnAbbrechen_Click);
        // 
        // lblStatus2
        // 
        this.lblStatus2.Margin = new System.Windows.Forms.Padding(2, 3, 0, 2);
        this.lblStatus2.Name = "lblStatus2";
        this.lblStatus2.Size = new System.Drawing.Size(235, 17);
        this.lblStatus2.Text = "Letzte Änderung: 2009-10-23  - Johann Weiher";
        // 
        // txtFunction
        // 
        this.txtFunction.Location = new System.Drawing.Point(161, 12);
        this.txtFunction.Name = "txtFunction";
        this.txtFunction.Size = new System.Drawing.Size(299, 20);
        this.txtFunction.TabIndex = 17;
        this.txtFunction.TextChanged += new System.EventHandler(this.txtFunction_TextChanged);
        this.txtFunction.Enter += new System.EventHandler(this.txtFunction_Enter);
        // 
        // label1
        // 
        this.label1.AutoSize = true;
        this.label1.Location = new System.Drawing.Point(12, 15);
        this.label1.Name = "label1";
        this.label1.Size = new System.Drawing.Size(120, 13);
        this.label1.TabIndex = 18;
        this.label1.Text = "Funktionale Zuordnung:";
        // 
        // label3
        // 
        this.label3.AutoSize = true;
        this.label3.Location = new System.Drawing.Point(12, 41);
        this.label3.Name = "label3";
        this.label3.Size = new System.Drawing.Size(43, 13);
        this.label3.TabIndex = 20;
        this.label3.Text = "Anlage:";
        // 
        // txtPlant
        // 
        this.txtPlant.Location = new System.Drawing.Point(161, 38);
        this.txtPlant.Name = "txtPlant";
        this.txtPlant.Size = new System.Drawing.Size(299, 20);
        this.txtPlant.TabIndex = 19;
        this.txtPlant.TextChanged += new System.EventHandler(this.txtPlant_TextChanged);
        this.txtPlant.Enter += new System.EventHandler(this.txtPlant_Enter);
        // 
        // label4
        // 
        this.label4.AutoSize = true;
        this.label4.Location = new System.Drawing.Point(12, 67);
        this.label4.Name = "label4";
        this.label4.Size = new System.Drawing.Size(56, 13);
        this.label4.TabIndex = 22;
        this.label4.Text = "Aufstellort:";
        // 
        // txtLocation
        // 
        this.txtLocation.Location = new System.Drawing.Point(161, 64);
        this.txtLocation.Name = "txtLocation";
        this.txtLocation.Size = new System.Drawing.Size(299, 20);
        this.txtLocation.TabIndex = 21;
        this.txtLocation.TextChanged += new System.EventHandler(this.txtLocation_TextChanged);
        this.txtLocation.Enter += new System.EventHandler(this.txtLocation_Enter);
        // 
        // label5
        // 
        this.label5.AutoSize = true;
        this.label5.Location = new System.Drawing.Point(12, 93);
        this.label5.Name = "label5";
        this.label5.Size = new System.Drawing.Size(55, 13);
        this.label5.TabIndex = 24;
        this.label5.Text = "Einbauort:";
        // 
        // txtMountLoc
        // 
        this.txtMountLoc.Location = new System.Drawing.Point(161, 90);
        this.txtMountLoc.Name = "txtMountLoc";
        this.txtMountLoc.Size = new System.Drawing.Size(299, 20);
        this.txtMountLoc.TabIndex = 23;
        this.txtMountLoc.TextChanged += new System.EventHandler(this.txtMountLoc_TextChanged);
        this.txtMountLoc.Enter += new System.EventHandler(this.txtMountLoc_Enter);
        // 
        // label6
        // 
        this.label6.AutoSize = true;
        this.label6.Location = new System.Drawing.Point(12, 119);
        this.label6.Name = "label6";
        this.label6.Size = new System.Drawing.Size(86, 13);
        this.label6.TabIndex = 26;
        this.label6.Text = "Anlagennummer:";
        // 
        // txtPlantNr
        // 
        this.txtPlantNr.Location = new System.Drawing.Point(161, 116);
        this.txtPlantNr.Name = "txtPlantNr";
        this.txtPlantNr.Size = new System.Drawing.Size(299, 20);
        this.txtPlantNr.TabIndex = 25;
        this.txtPlantNr.TextChanged += new System.EventHandler(this.txtPlantNr_TextChanged);
        this.txtPlantNr.Enter += new System.EventHandler(this.txtPlantNr_Enter);
        // 
        // label7
        // 
        this.label7.AutoSize = true;
        this.label7.Location = new System.Drawing.Point(12, 145);
        this.label7.Name = "label7";
        this.label7.Size = new System.Drawing.Size(83, 13);
        this.label7.TabIndex = 28;
        this.label7.Text = "Dokumentenart:";
        // 
        // txtDocument
        // 
        this.txtDocument.Location = new System.Drawing.Point(161, 142);
        this.txtDocument.Name = "txtDocument";
        this.txtDocument.Size = new System.Drawing.Size(299, 20);
        this.txtDocument.TabIndex = 27;
        this.txtDocument.TextChanged += new System.EventHandler(this.txtDocument_TextChanged);
        this.txtDocument.Enter += new System.EventHandler(this.txtDocument_Enter);
        // 
        // label8
        // 
        this.label8.AutoSize = true;
        this.label8.Location = new System.Drawing.Point(12, 171);
        this.label8.Name = "label8";
        this.label8.Size = new System.Drawing.Size(89, 13);
        this.label8.TabIndex = 30;
        this.label8.Text = "Benutzerdefiniert:";
        // 
        // txtUserDef
        // 
        this.txtUserDef.Location = new System.Drawing.Point(161, 168);
        this.txtUserDef.Name = "txtUserDef";
        this.txtUserDef.Size = new System.Drawing.Size(299, 20);
        this.txtUserDef.TabIndex = 29;
        this.txtUserDef.TextChanged += new System.EventHandler(this.txtUserDef_TextChanged);
        this.txtUserDef.Enter += new System.EventHandler(this.txtUserDef_Enter);
        // 
        // label9
        // 
        this.label9.AutoSize = true;
        this.label9.Location = new System.Drawing.Point(12, 197);
        this.label9.Name = "label9";
        this.label9.Size = new System.Drawing.Size(66, 13);
        this.label9.TabIndex = 32;
        this.label9.Text = "Seitenname:";
        // 
        // txtPagename
        // 
        this.txtPagename.Location = new System.Drawing.Point(161, 194);
        this.txtPagename.Name = "txtPagename";
        this.txtPagename.Size = new System.Drawing.Size(299, 20);
        this.txtPagename.TabIndex = 31;
        this.txtPagename.TextChanged += new System.EventHandler(this.txtPagename_TextChanged);
        this.txtPagename.Enter += new System.EventHandler(this.txtPagename_Enter);
        // 
        // textBox1
        // 
        this.textBox1.Enabled = false;
        this.textBox1.Location = new System.Drawing.Point(138, 12);
        this.textBox1.Name = "textBox1";
        this.textBox1.ReadOnly = true;
        this.textBox1.Size = new System.Drawing.Size(20, 20);
        this.textBox1.TabIndex = 33;
        this.textBox1.Text = "==";
        this.textBox1.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
        // 
        // textBox2
        // 
        this.textBox2.Enabled = false;
        this.textBox2.Location = new System.Drawing.Point(138, 38);
        this.textBox2.Name = "textBox2";
        this.textBox2.ReadOnly = true;
        this.textBox2.Size = new System.Drawing.Size(20, 20);
        this.textBox2.TabIndex = 34;
        this.textBox2.Text = "=";
        this.textBox2.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
        // 
        // textBox3
        // 
        this.textBox3.Enabled = false;
        this.textBox3.Location = new System.Drawing.Point(138, 64);
        this.textBox3.Name = "textBox3";
        this.textBox3.ReadOnly = true;
        this.textBox3.Size = new System.Drawing.Size(20, 20);
        this.textBox3.TabIndex = 35;
        this.textBox3.Text = "++";
        this.textBox3.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
        // 
        // textBox4
        // 
        this.textBox4.Enabled = false;
        this.textBox4.Location = new System.Drawing.Point(138, 90);
        this.textBox4.Name = "textBox4";
        this.textBox4.ReadOnly = true;
        this.textBox4.Size = new System.Drawing.Size(20, 20);
        this.textBox4.TabIndex = 36;
        this.textBox4.Text = "+";
        this.textBox4.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
        // 
        // txtPlantNrIndex
        // 
        this.txtPlantNrIndex.Enabled = false;
        this.txtPlantNrIndex.Location = new System.Drawing.Point(138, 116);
        this.txtPlantNrIndex.Name = "txtPlantNrIndex";
        this.txtPlantNrIndex.ReadOnly = true;
        this.txtPlantNrIndex.Size = new System.Drawing.Size(20, 20);
        this.txtPlantNrIndex.TabIndex = 37;
        this.txtPlantNrIndex.Text = "%";
        this.txtPlantNrIndex.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
        // 
        // textBox6
        // 
        this.textBox6.Enabled = false;
        this.textBox6.Location = new System.Drawing.Point(138, 142);
        this.textBox6.Name = "textBox6";
        this.textBox6.ReadOnly = true;
        this.textBox6.Size = new System.Drawing.Size(20, 20);
        this.textBox6.TabIndex = 38;
        this.textBox6.Text = "&";
        this.textBox6.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
        // 
        // textBox7
        // 
        this.textBox7.Enabled = false;
        this.textBox7.Location = new System.Drawing.Point(138, 168);
        this.textBox7.Name = "textBox7";
        this.textBox7.ReadOnly = true;
        this.textBox7.Size = new System.Drawing.Size(20, 20);
        this.textBox7.TabIndex = 39;
        this.textBox7.Text = "#";
        this.textBox7.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
        // 
        // textBox8
        // 
        this.textBox8.Enabled = false;
        this.textBox8.Location = new System.Drawing.Point(138, 194);
        this.textBox8.Name = "textBox8";
        this.textBox8.ReadOnly = true;
        this.textBox8.Size = new System.Drawing.Size(20, 20);
        this.textBox8.TabIndex = 40;
        this.textBox8.Text = "/";
        this.textBox8.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
        // 
        // label10
        // 
        this.label10.AutoSize = true;
        this.label10.Font = new System.Drawing.Font("Wingdings", 16.16327F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(2)));
        this.label10.Location = new System.Drawing.Point(2, 221);
        this.label10.Name = "label10";
        this.label10.Size = new System.Drawing.Size(28, 26);
        this.label10.TabIndex = 41;
        this.label10.Text = "2";
        // 
        // txtFullPagename
        // 
        this.txtFullPagename.Location = new System.Drawing.Point(28, 224);
        this.txtFullPagename.Name = "txtFullPagename";
        this.txtFullPagename.Size = new System.Drawing.Size(276, 20);
        this.txtFullPagename.TabIndex = 43;
        this.txtFullPagename.KeyPress += new System.Windows.Forms.KeyPressEventHandler(keyPress);

        // 
        // FrmOpenPage
        // 
        this.AcceptButton = this.btnOK;
        this.AutoScaleDimensions = new System.Drawing.SizeF(6F, 13F);
        this.AutoScaleMode = System.Windows.Forms.AutoScaleMode.Font;
        this.CancelButton = this.btnCancel;
        this.ClientSize = new System.Drawing.Size(472, 257);
        this.Controls.Add(this.txtFullPagename);
        this.Controls.Add(this.label10);
        this.Controls.Add(this.textBox8);
        this.Controls.Add(this.txtPagename);
        this.Controls.Add(this.txtUserDef);
        this.Controls.Add(this.txtDocument);
        this.Controls.Add(this.txtPlantNr);
        this.Controls.Add(this.txtMountLoc);
        this.Controls.Add(this.txtLocation);
        this.Controls.Add(this.txtPlant);
        this.Controls.Add(this.txtFunction);
        this.Controls.Add(this.textBox7);
        this.Controls.Add(this.textBox6);
        this.Controls.Add(this.txtPlantNrIndex);
        this.Controls.Add(this.textBox4);
        this.Controls.Add(this.textBox3);
        this.Controls.Add(this.textBox2);
        this.Controls.Add(this.textBox1);
        this.Controls.Add(this.label9);
        this.Controls.Add(this.label8);
        this.Controls.Add(this.label7);
        this.Controls.Add(this.label6);
        this.Controls.Add(this.label5);
        this.Controls.Add(this.label4);
        this.Controls.Add(this.label3);
        this.Controls.Add(this.label1);
        this.Controls.Add(this.btnCancel);
        this.Controls.Add(this.btnOK);
        this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
        this.MaximizeBox = false;
        this.MaximumSize = new System.Drawing.Size(800, 800);
        this.MinimizeBox = false;
        this.Name = "FrmOpenPage";
        this.ShowIcon = false;
        this.ShowInTaskbar = false;
        this.Load += new System.EventHandler(this.FrmOpenPage_Load);
        this.ResumeLayout(false);
        this.PerformLayout();

    }

    #endregion

    private System.Windows.Forms.Button btnOK;

    # endregion // Code für das Formular

    // Action
    [DeclareAction("OpenPage")]

    public void OpenPageVoid()
    {
        ////////////////////////////////////////////////////////////////////////
        // Open dialog
        ////////////////////////////////////////////////////////////////////////
        string sProjectname = PathMap.SubstitutePath("$(PROJECTNAME)");

        FrmOpenPage Frm1 = new FrmOpenPage();
        Frm1.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;

        // Titel
        Frm1.Text = "OpenPage [Project: " + sProjectname + "]";

        Frm1.ShowDialog();
        return;
    }

    private void FrmOpenPage_Load(object sender, System.EventArgs e)
    {
        ////////////////////////////////////////////////////////////////////////
        // Loading dialog
        ////////////////////////////////////////////////////////////////////////

        // Select Page
        new CommandLineInterpreter().Execute("XGedSelectPageAction");

        // Pagename Tempdata
        string sPageNameFile = @"C:\TEMP\OpenPageTemp.txt";

        // Export Pagename
        ActionCallingContext contextPageName = new ActionCallingContext();
        contextPageName.AddParameter("ConfigScheme", "ePlanus - OpenPage");
        contextPageName.AddParameter("Destination", sPageNameFile);
        contextPageName.AddParameter("ExecutionMode", "0");
        new CommandLineInterpreter().Execute("XMExportPagesAction", contextPageName);

        // Get Line in Tempdata
        string sLine3 = "";
        int iLine = 3;
        float fRow = 0;
        if (File.Exists(sPageNameFile))
        {
            StreamReader myFile = new StreamReader(sPageNameFile, System.Text.Encoding.Default);
            while (!myFile.EndOfStream && fRow < iLine)
            {
                fRow++;
                sLine3 = myFile.ReadLine();
            }
            myFile.Close();
            if (fRow < iLine)
                sLine3 = "";
        }

        // Split Line
        string[] slPageLine = sLine3.Split('\t');

        // Split Parameters
        string[] slPageParameters = slPageLine[2].Split(';');
        // 0 = Function
        // 1 = Plant
        // 2 = Location
        // 3 = Mount location
        // 4 = Plantnumber
        // 5 = Document
        // 6 = Defined by User
        // 7 = Pagename
        // 8 = FullPagename


        // Split Function
        txtFunction.Text = slPageParameters[0].Substring(2);

        // Split Plant
        txtPlant.Text = slPageParameters[1].Substring(1);

        // Split Location
        txtLocation.Text = slPageParameters[2].Substring(2);

        // Split Mount location
        txtMountLoc.Text = slPageParameters[3].Substring(1);

        // Split Plantnumber
        txtPlantNr.Text = slPageParameters[4].Substring(1); // Plantnumber = 1 Char (2 Chars = "2")
   
        // ---> Split Plantnumber identifier
        string sPlantNrIndex = slPageParameters[4].Substring(0, 1); // Plantnumber = 1 Char (2 Chars = "0, 2")
        txtPlantNrIndex.Text = sPlantNrIndex; // Plantnumber

        // Split Document
        txtDocument.Text = slPageParameters[5].Substring(1);

        // Split Defined by User
        txtUserDef.Text = slPageParameters[6].Substring(1);

        // Split Pagename
        txtPagename.Text = slPageParameters[7];

        // Split FullPagename
        txtFullPagename.Text = slPageParameters[8];

        txtFullPagename.Select();

    }


    public void btnOK_Click(object sender, System.EventArgs e)
    {
        ////////////////////////////////////////////////////////////////////////
        // Button: OK
        ////////////////////////////////////////////////////////////////////////

        Refresh();

        // Open Page
        ActionCallingContext context = new ActionCallingContext();
        context.AddParameter("PAGENAME", txtFullPagename.Text);
        new CommandLineInterpreter().Execute("edit", context);

        // Close Form
        Close();
        return;
    }

    private void btnAbbrechen_Click(object sender, System.EventArgs e)
    {
        ////////////////////////////////////////////////////////////////////////
        // Button Cancel
        ////////////////////////////////////////////////////////////////////////

        Close();
        return;
    }

    public void GetPagename()
    {
        ////////////////////////////////////////////////////////////////////////
        // Generate new pagename
        ////////////////////////////////////////////////////////////////////////

        // Function
        if (txtFunction.Text != "")
        {
            txtFullPagename.Text = txtFullPagename.Text + "==" + txtFunction.Text;
        }

        // Plant
        if (txtPlant.Text != "")
        {
            txtFullPagename.Text = txtFullPagename.Text + "=" + txtPlant.Text;
        }

        // Location
        if (txtLocation.Text != "")
        {
            txtFullPagename.Text = txtFullPagename.Text + "++" + txtLocation.Text;
        }

        // Mount location
        if (txtMountLoc.Text != "")
        {
            txtFullPagename.Text = txtFullPagename.Text + "+" + txtMountLoc.Text;
        }

        // Plantnumber
        if (txtPlantNr.Text != "")
        {
            txtFullPagename.Text = txtFullPagename.Text + txtPlantNrIndex.Text + txtPlantNr.Text;
        }

        // Document
        if (txtDocument.Text != "")
        {
            txtFullPagename.Text = txtFullPagename.Text + "&&" + txtDocument.Text;
        }

        // Defined by User
        if (txtUserDef.Text != "")
        {
            txtFullPagename.Text = txtFullPagename.Text + "#" + txtUserDef.Text;
        }

        // Pagename
        if (txtPagename.Text != "")
        {
            txtFullPagename.Text = txtFullPagename.Text + "/" + txtPagename.Text;
        }

        return;
    }

    ////////////////////////////////////////////////////////////////////////
    // Keyevent
    ////////////////////////////////////////////////////////////////////////
    private void keyPress(object sender, System.Windows.Forms.KeyPressEventArgs e)
    {
        if (e.KeyChar == (char)13)
        {
            // Open Page
            ActionCallingContext context = new ActionCallingContext();
            context.AddParameter("PAGENAME", txtFullPagename.Text);
            new CommandLineInterpreter().Execute("edit", context);

            // Close Form
            Close();
            return;
        }
    }


    ////////////////////////////////////////////////////////////////////////
    // Select Content in textboxes
    ////////////////////////////////////////////////////////////////////////
    private void txtFunction_Enter(object sender, System.EventArgs e)
    {
        txtFunction.SelectAll();
    }

    private void txtPlant_Enter(object sender, System.EventArgs e)
    {
        txtPlant.SelectAll();
    }

    private void txtLocation_Enter(object sender, System.EventArgs e)
    {
        txtLocation.SelectAll();
    }

    private void txtMountLoc_Enter(object sender, System.EventArgs e)
    {
        txtMountLoc.SelectAll();
    }

    private void txtPlantNr_Enter(object sender, System.EventArgs e)
    {
        txtPlantNr.SelectAll();
    }

    private void txtDocument_Enter(object sender, System.EventArgs e)
    {
        txtDocument.SelectAll();
    }

    private void txtUserDef_Enter(object sender, System.EventArgs e)
    {
        txtUserDef.SelectAll();
    }

    private void txtPagename_Enter(object sender, System.EventArgs e)
    {
        txtPagename.SelectAll();
    }


    ////////////////////////////////////////////////////////////////////////
    // Display new Pagename in Label
    ////////////////////////////////////////////////////////////////////////

    private void txtFunction_TextChanged(object sender, System.EventArgs e)
    {
        txtFullPagename.Text = "";
        GetPagename();
    }

    public void txtPlant_TextChanged(object sender, System.EventArgs e)
    {
        txtFullPagename.Text = "";
        GetPagename();
    }

    private void txtLocation_TextChanged(object sender, System.EventArgs e)
    {
        txtFullPagename.Text = "";
        GetPagename();
    }

    private void txtMountLoc_TextChanged(object sender, System.EventArgs e)
    {
        txtFullPagename.Text = "";
        GetPagename();
    }

    private void txtPlantNr_TextChanged(object sender, System.EventArgs e)
    {
        txtFullPagename.Text = "";
        GetPagename();
    }

    private void txtDocument_TextChanged(object sender, System.EventArgs e)
    {
        txtFullPagename.Text = "";
        GetPagename();
    }

    private void txtUserDef_TextChanged(object sender, System.EventArgs e)
    {
        txtFullPagename.Text = "";
        GetPagename();
    }

    private void txtPagename_TextChanged(object sender, System.EventArgs e)
    {
        txtFullPagename.Text = "";
        GetPagename();
    }

    [DeclareMenu]
    public void MenuFunction()
    {
        uint intIDUntermenue1;                                             // MenuID
        Eplan.EplApi.Gui.Menu oMenu = new Eplan.EplApi.Gui.Menu();
        intIDUntermenue1 = oMenu.AddMainMenu(
            "ePlanus",                                                     // Hauptmenüname
            "Hilfe",                                                       // neben Menüpunkt...
            "< ePlanus.de >",                                              // Menüpunktname
            "ePlanus",                                                     // Action
            "ePlanus.de - Scripting in Eplan ist einfach (toll)",          // Statustext
            1                                                              // Hinter Menüpunkt x
        );

        // Untermenüpunkte
        oMenu.AddMenuItem(
            "OpenPage",                                                     // Menüpunktname
            "OpenPage",                                                     // Action
            "Öffnet eingegebene Seite",                                     // Statustext
            intIDUntermenue1,                                               // Menü-ID
            1,                                                              // 1 = Hinter Menüpunkt X
            false,                                                          // Seperator davor
            false                                                           // Seperator dahinter
        );

    }

}
